import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../data/controller/deposit/add_new_deposit_controller.dart';
import '../../../components/row_widget/custom_row.dart';

class InfoWidget extends StatelessWidget {
  const InfoWidget({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<AddNewDepositController>(builder: (controller) {
      bool showRate = controller.isShowRate();
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const SizedBox(
            height: Dimensions.space20,
          ),
          Container(
            padding: const EdgeInsets.all(10),
            decoration: BoxDecoration(borderRadius: BorderRadius.circular(Dimensions.defaultRadius), border: Border.all(color: MyColor.borderColor)),
            child: Column(
              children: [
                const SizedBox(
                  height: 15,
                ),
                CustomRow(
                  firstText: MyStrings.payableAmount.tr,
                  lastText: "${controller.amountController.text} ${controller.currency}",
                ),
                CustomRow(
                  firstText: "${MyStrings.inText.tr} ${controller.depositRepo.apiClient.getCurrencyOrUsername(isCurrency: true)}",
                  lastText: "${controller.amountInBaseCurrencyController.text} ${controller.depositRepo.apiClient.getCurrencyOrUsername(isCurrency: true)}",
                ),
                CustomRow(
                  firstText: MyStrings.depositLimit.tr,
                  lastText: controller.depositLimit,
                ),
                CustomRow(
                  firstText: MyStrings.gatewayCharge.tr,
                  lastText: controller.gateWayCharge,
                ),
                CustomRow(
                  firstText: MyStrings.payableInCludeCharge.tr,
                  lastText: controller.payableIncludeChage,
                ),
                if (showRate)
                  CustomRow(
                    firstText: MyStrings.conversionRate.tr,
                    lastText: controller.conversionRate,
                  ),
                CustomRow(
                  firstText: '${MyStrings.inText}  ${controller.paymentMethod?.currency}'.tr,
                  lastText: controller.conversionTotalAmount,
                  showDivider: false,
                ),
                const SizedBox(
                  height: 10,
                ),
              ],
            ),
          ),
        ],
      );
    });
  }
}
